<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (empty($data["BKash"]) && empty($data["Nagad"]) && empty($data["Roket"]) && empty($data["Upay"])) {
        echo json_encode(["status" => "error", "message" => "At least one number is required"]);
        exit;
    }

    $BKash = trim($data["BKash"]);
    $Nagad = trim($data["Nagad"]);
    $Roket = trim($data["Roket"]);
    $Upay  = trim($data["Upay"]);

    $sql = "INSERT INTO `number` (`id`, `BKash`, `Nagad`, `Roket`, `Upay`) 
            VALUES (1, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE 
                `BKash` = VALUES(`BKash`),
                `Nagad` = VALUES(`Nagad`),
                `Roket` = VALUES(`Roket`),
                `Upay` = VALUES(`Upay`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $BKash, $Nagad, $Roket, $Upay);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Number saved successfully (always ID=1)",
            "id" => 1,
            "BKash" => $BKash,
            "Nagad" => $Nagad,
            "Roket" => $Roket,
            "Upay" => $Upay,
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed",
            "error" => $stmt->error
        ]);
    }

    $stmt->close();
} 
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `number` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status" => "success",
            "id" => $row["id"],
            "BKash" => $row["BKash"],
            "Nagad" => $row["Nagad"],
            "Roket" => $row["Roket"],
            "Upay" => $row["Upay"],
            "created_at" => $row["created_at"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No Number found"
        ]);
    }
}

$conn->close();
?>